script_changed = false;

function GetUrlAsString(url) {
	url = url.replace("http://","");
	host = url.substring(0,url.indexOf("/"));
	page = url.replace(host, "");
	var port = 80;
	var socket = OpenAddress(host, port);
	var http_type = "HTTP/1.1";
	var get = "GET "+page+" "+http_type;
	var user_agent = "SphereWeb/0.1 Sphere/1.5";
	var accept_language = "en-us,en;q=0.5";
	var page_data = "";
	var header = [];

	while(!socket.isConnected()) {}
	socket.write(CreateByteArrayFromString(get+"\n"+
	"Host: "+host+"\r\n"+
	"User-Agent: "+user_agent+"\r\n"+
	"Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\n"+
	"Accept-Language: "+accept_language+"\r\n"+
	"Connection: keep-alive\r\n"+
	"\r\n"
));
	while(true) {
		packet_size = socket.getPendingReadSize();
		if(packet_size>0) {
			packet=socket.read(packet_size);
			page_data += CreateStringFromByteArray(packet);
			if(header.length<1) {
				header = page_data.substring(0,page_data.indexOf("\r\n\r\n"));
				page_data = page_data.replace(header+"\r\n\r\n","");
				header = header.split("\r\n");
				for(i=0;i<header.length;i++) {
					tmp = header[i].split(": ");
					header[tmp[0]] = tmp[1]
				}
			}
		}			
		if(header["Content-Length"] <= page_data.length) break;
	}
	return page_data;
}

function DownloadUrl(url, loc) {
	url = url.replace("http://","");
	host = url.substring(0,url.indexOf("/"));
	page = url.replace(host, "");
	var port = 80;
	var socket = OpenAddress(host, port);
	var http_type = "HTTP/1.1";
	var get = "GET "+page+" "+http_type;
	var user_agent = "SphereWeb/0.1 Sphere/1.5";
	var accept_language = "en-us,en;q=0.5";
	var page_data = "";
	var header = [];
	var temp_file = OpenRawFile("../tmp", true);
	var file = OpenRawFile(loc, true);

	while(!socket.isConnected()) {}
	socket.write(CreateByteArrayFromString(get+"\n"+
	"Host: "+host+"\r\n"+
	"User-Agent: "+user_agent+"\r\n"+
	"Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\n"+
	"Accept-Language: "+accept_language+"\r\n"+
	"Connection: keep-alive\r\n"+
	"\r\n"
));
	while(true) {
		packet_size = socket.getPendingReadSize();
		if(packet_size>0) {
			packet=socket.read(packet_size);
			temp_file.write(packet)
			page_data += CreateStringFromByteArray(packet);
			if(header.length<1) {
				var end_of_header = page_data.indexOf("\r\n\r\n")+4;
				header = page_data.substring(0,page_data.indexOf("\r\n\r\n"));
				page_data = page_data.replace(header+"\r\n\r\n","");
				header = header.split("\r\n");
				for(i=0;i<header.length;i++) {
					tmp = header[i].split(": ");
					header[tmp[0]] = tmp[1]
				}
			}

		}
		if(header["Content-Length"] <= page_data.length) break;
	}
	temp_file.close();
	var temp_file = OpenRawFile("../tmp", false);
	temp_file.setPosition(end_of_header);
	file.write(temp_file.read(temp_file.getSize()));
	temp_file.close();
	file.close();
	RemoveFile("tmp");
	file.close
}

function WriteFile(str,file) {
	var output = OpenRawFile(file, true);
	output.write(CreateByteArrayFromString(str));
	output.close();
}

function FileExists(loc) {
	file = loc.substring(loc.lastIndexOf("/")+1, loc.length);
	dir = loc.replace(file, "");
	file_list = GetFileList(dir);
	for(i=0;i<file_list.length;i++) {
		if(file == file_list[i]) return true;
	}
	return false;
}

function UpdateGame() {
	Rectangle(0,0,SW,SH,Black);
	GetSystemFont().drawZoomedText(0,0, 2,"CHECKING FOR UPDATES. PLEASE WAIT...");
	FlipScreen();
	var map_list = GetUrlAsString("http://eggbertx.theoks.net/secret_collect/maps.txt").split("\n");
	var scripts_list = GetUrlAsString("http://eggbertx.theoks.net/secret_collect/scripts.txt").split("\n");
	var sprites_list = GetUrlAsString("http://eggbertx.theoks.net/secret_collect/spritesets.txt").split("\n");
	var images_list = GetUrlAsString("http://eggbertx.theoks.net/secret_collect/images.txt").split("\n");
	var sounds_list = GetUrlAsString("http://eggbertx.theoks.net/secret_collect/sounds.txt").split("\n");
	var fonts_list = GetUrlAsString("http://eggbertx.theoks.net/secret_collect/fonts.txt").split("\n");
	for(i=0;i<scripts_list.length;i++) {
		pair = scripts_list[i].split(",");
		script = pair[0].replace("http://eggbertx.theoks.net/secret_collect/","");
		hash = pair[1];
		if(pair[0][0]=="-") {
			if(FileExists(pair[0].substring(1,pair[0].length))) RemoveFile(pair[0].substring(1,pair[0].length));
		} else if(!FileExists(script) || HashFromFile("../"+script) != hash) { 
			script_changed = true;
			WriteFile(GetUrlAsString("http://eggbertx.theoks.net/secret_collect/"+script), "../"+script) 
		}
	}
	if(script_changed) ExecuteGame("Secret_Collect");
	for(i=0;i<map_list.length;i++) {
		pair = map_list[i].split(",");
		map = pair[0].replace("http://eggbertx.theoks.net/secret_collect/","");
		hash = pair[1];
		if(pair[0][0]=="-") {
			if(FileExists(pair[0].substring(1,pair[0].length))) RemoveFile(pair[0].substring(1,pair[0].length));
		} else if(!FileExists(map) || HashFromFile("../"+map) != hash) { 
			DownloadUrl("http://eggbertx.theoks.net/secret_collect/"+map, "../"+map) 
		}
	}
	for(i=0;i<sprites_list.length;i++) {
		pair = sprites_list[i].split(",");
		sprite = pair[0].replace("http://eggbertx.theoks.net/secret_collect/","");
		hash = pair[1];
		if(pair[0][0]=="-") {
			if(FileExists(pair[0].substring(1,pair[0].length))) RemoveFile(pair[0].substring(1,pair[0].length));
		} else if(!FileExists(sprite) || HashFromFile("../"+sprite) != hash) { 
			DownloadUrl("http://eggbertx.theoks.net/secret_collect/"+sprite, "../"+sprite) 
		}
	}
	for(i=0;i<images_list.length;i++) {
		pair = images_list[i].split(",");
		image = pair[0].replace("http://eggbertx.theoks.net/secret_collect/","");
		hash = pair[1];
		if(pair[0][0]=="-") {
			if(FileExists(pair[0].substring(1,pair[0].length))) RemoveFile(pair[0].substring(1,pair[0].length));
		} else if(!FileExists(image) || HashFromFile("../"+image) != hash) { 
			DownloadUrl("http://eggbertx.theoks.net/secret_collect/"+image, ".."+image) 
		}
	}
	for(i=0;i<sounds_list.length;i++) {
		pair = sounds_list[i].split(",");
		sound = pair[0].replace("http://eggbertx.theoks.net/secret_collect/","");
		hash = pair[1];
		if(pair[0][0]=="-") {
			if(FileExists(pair[0].substring(1,pair[0].length))) RemoveFile(pair[0].substring(1,pair[0].length));
		} else if(!FileExists(sound) || HashFromFile("../"+sound) != hash) { 
			DownloadUrl("http://eggbertx.theoks.net/secret_collect/"+sound, "../"+sound) 
		}
	}
	for(i=0;i<fonts_list.length;i++) {
		pair = fonts_list[i].split(",");
		font_ = pair[0].replace("http://eggbertx.theoks.net/secret_collect/","");
		hash = pair[1];
		if(pair[0][0]=="-") {
			if(FileExists(pair[0].substring(1,pair[0].length))) RemoveFile(pair[0].substring(1,pair[0].length));
		} else if(!FileExists(font_) || HashFromFile("../"+font_) != hash) { 
			DownloadUrl("http://eggbertx.theoks.net/secret_collect/"+font_, ".."+font_) 
		}
	}
}
